/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.capture.action;

import io.github.mortuusars.exposure.client.capture.action.DisablePostEffectAction;
import io.github.mortuusars.exposure.client.capture.action.FlashAction;
import io.github.mortuusars.exposure.client.capture.action.ForceCameraTypeAction;
import io.github.mortuusars.exposure.client.capture.action.ForceRegularOrSelfieCameraTypeAction;
import io.github.mortuusars.exposure.client.capture.action.HideGuiAction;
import io.github.mortuusars.exposure.client.capture.action.InterplanarProjectionAction;
import io.github.mortuusars.exposure.client.capture.action.ModifyGammaAction;
import io.github.mortuusars.exposure.client.capture.action.SetCameraEntityAction;
import io.github.mortuusars.exposure.client.capture.action.SetFovAction;
import io.github.mortuusars.exposure.client.capture.action.SetPostEffectAction;
import io.github.mortuusars.exposure.util.TranslatableError;
import io.github.mortuusars.exposure.world.camera.CameraId;
import io.github.mortuusars.exposure.world.camera.component.ShutterSpeed;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_5498;

public interface CaptureAction {
    public static final CaptureAction EMPTY = new CaptureAction(){};

    default public int requiredDelayTicks() {
        return 0;
    }

    default public void initialize() {
    }

    default public void delayTick(int delayTicksLeft) {
    }

    default public void beforeCapture() {
    }

    default public void onSuccess() {
    }

    default public void onFailure(TranslatableError error) {
    }

    default public void afterCapture() {
    }

    public static CaptureAction forceCamera(class_5498 cameraType) {
        return new ForceCameraTypeAction(cameraType);
    }

    public static CaptureAction forceRegularOrSelfieCamera() {
        return new ForceRegularOrSelfieCameraTypeAction();
    }

    public static CaptureAction hideGui() {
        return new HideGuiAction();
    }

    public static CaptureAction disablePostEffect() {
        return new DisablePostEffectAction();
    }

    public static CaptureAction setPostEffect(class_2960 postEffect) {
        return new SetPostEffectAction(postEffect);
    }

    public static CaptureAction modifyGamma(ShutterSpeed shutterSpeed) {
        return shutterSpeed != ShutterSpeed.DEFAULT ? new ModifyGammaAction(shutterSpeed) : EMPTY;
    }

    public static CaptureAction flash(class_1297 photographer) {
        return new FlashAction(photographer);
    }

    public static CaptureAction interplanarProjection(CameraId cameraId) {
        return new InterplanarProjectionAction(cameraId);
    }

    public static CaptureAction setCameraEntity(class_1297 viewEntity) {
        return new SetCameraEntityAction(viewEntity);
    }

    public static CaptureAction setFov(double fov) {
        return new SetFovAction(fov);
    }

    default public CaptureAction orElse(Supplier<CaptureAction> action) {
        return this.equals(EMPTY) ? action.get() : this;
    }

    public static CaptureAction optional(boolean predicate, Supplier<CaptureAction> componentSupplier) {
        return predicate ? componentSupplier.get() : EMPTY;
    }

    public static CaptureAction optional(boolean predicate, CaptureAction component) {
        return predicate ? component : EMPTY;
    }

    public static CaptureAction optional(Optional<CaptureAction> optional) {
        return optional.orElse(EMPTY);
    }

    public static <T> CaptureAction optional(Optional<T> optional, Function<T, CaptureAction> ifPresent) {
        return optional.map(ifPresent).orElse(EMPTY);
    }
}

